define(['DirectSchedulingService','InstitutionChoiceController'], function () {
	'use strict';

	describe('Institution choice controller', function () {
		var scope,
			controller,
			mhpuser,
			stateMock,
			stateParamsMock,
			institutionsServiceMock;

		beforeEach(function () {
			module('angularTemplateApp');

			mhpuser = {
				facilityName: 'Test Facility',
				firstName: 'Test First',
				lastName: 'Test Last'
			};

			stateMock = {
				go: function () {
				}
			};

			stateParamsMock = {
				moduleName: "VAR Utility",
				primaryHeaderTitle: "Select Facility Location"
			};

			institutionsServiceMock = {
				institutions: {
					data: [
						{divisionName: 'Division 2'},
						{divisionName: 'Division 1'},
						{divisionName: mhpuser.facilityName},
					]
				},
				setActiveInstitution: function () {
				}
			};

			spyOn(institutionsServiceMock, 'setActiveInstitution');
			spyOn(stateMock, 'go');

			module(function ($provide) {
				$provide.value('mhpuser', mhpuser);
				$provide.value('$state', stateMock);
				$provide.value('$stateParams', stateParamsMock);
				$provide.value('InstitutionsService', institutionsServiceMock);
			});

			inject(function ($rootScope, $controller) {
				scope = $rootScope.$new();
				controller = $controller('InstitutionChoiceController', {$scope: scope, $stateParams: stateParamsMock});
			});
		});

		it('sets scope variables properly from service values and state params', function () {
			expect(scope.primaryHeaderTitle).toEqual('VAR Utility - Select Facility Location');
			expect(scope.parentFacilityName).toEqual('Test Facility');
			expect(scope.userFirstLastName).toEqual('Test First Test Last');
		});

		it('on openSettings() sets the active institution in the institutions service and forwards the user to the main var-utility page', function () {
			var institutionSelection = {
				dummyField: "dummy data"
			};
			scope.openSettings(institutionSelection);
			expect(institutionsServiceMock.setActiveInstitution)
				.toHaveBeenCalledWith(institutionSelection);
			expect(stateMock.go)
				.toHaveBeenCalledWith("main.auth.two-panel.secondary-navigation.var-utility");
		});

		it('should sort institution dropdown options alphabetically, but always put the parent facility first', function () {
			expect(scope.institutionOptions).toEqual([mhpuser.facilityName, 'Division 1', 'Division 2']);
		});
	});
});